const combinations = ['A0', 'B1', 'C2', 'D3', 'E4', 'F5', 'G6', 'H7', 'I8', 'J9'];
let board = [];
let firstSelection = null;
let secondSelection = null;
let pairsFound = 0;
let moves = 0;

document.getElementById('playButton').addEventListener('click', startGame);

function startGame() {
    board = [...combinations, ...combinations].sort(() => Math.random() - 0.5);
    pairsFound = 0;
    moves = 0;
    firstSelection = null;
    secondSelection = null;
    renderBoard();
    setTimeout(hideBoard, 5000);
}

function renderBoard() {
    const rows = [document.getElementById('row1'), document.getElementById('row2'), document.getElementById('row3'), document.getElementById('row4')];
    rows.forEach(row => row.innerHTML = '');
    
    for (let i = 0; i < 5; i++) {
        for (let j = 0; j < 4; j++) {
            const cell = document.createElement('td');
            cell.textContent = board[j * 5 + i];
            cell.dataset.index = j * 5 + i;
            rows[j].appendChild(cell);
        }
    }
}

function hideBoard() {
    const cells = document.querySelectorAll('td');
    cells.forEach(cell => {
        cell.textContent = '';
        cell.classList.add('hidden');
        cell.addEventListener('click', handleCellClick);
    });
}

function handleCellClick(event) {
    const cell = event.target;
    const index = cell.dataset.index;

    if (!firstSelection) {
        firstSelection = cell;
        cell.textContent = board[index];
        cell.classList.remove('hidden');
    } else if (!secondSelection && cell !== firstSelection) {
        secondSelection = cell;
        cell.textContent = board[index];
        cell.classList.remove('hidden');

        moves++;

        if (firstSelection.textContent === secondSelection.textContent) {
            pairsFound++;
            firstSelection = null;
            secondSelection = null;

            if (pairsFound === 10) {
                alert(`Você venceu com ${moves} jogadas!`);
            }
        } else {
            setTimeout(() => {
                firstSelection.textContent = '';
                secondSelection.textContent = '';
                firstSelection.classList.add('hidden');
                secondSelection.classList.add('hidden');
                firstSelection = null;
                secondSelection = null;
            }, 1000);
        }
    }
}
